# KVERKOM Simple Python Client

Command line klient pre NOP API (projekt KVERKOM).

## Prerequisities

- python 3.11+

## Installation
Odporúčame vytvoriť (použiť) venv (virtual envirnoment), napr.:
```
cd /path/to/your/project
python -m venv .venv
source .venv/bin/activate
python -m pip install --upgrade pip
python -m pip install -r requirements.txt
```
Do adresára `cert` je potrebné nakopírovať klientsky certifikát a kľúč k nemu, ideálne pomenované ako
`kverkom-int-client.pem` a `kverkom-int-client.key` (resp. viď konfiguráciu v skripte).

## Running

### kverkom_cmd
```
usage: kverkom_test.py [-h] {erpStatus,bankStatus,newTransaction,getAllTransactions,wait,notify,erp} [-d] ...

Simulátor ERP a Banky pre projekt KVERKOM

positional arguments:
  {erpStatus,bankStatus,newTransaction,getAllTransactions,wait,notify,erp}
    erpStatus           Zistiť status ERP API
    bankStatus          Zistiť status Bank API
    newTransaction      Vygenerovať nové TransactionId
    getAllTransactions  Získať všetky transakcie pre pokladnicu
    wait                Čakať na stav transakcie
    notify              Odoslať notifikáciu o platbe
    erp                 Spustiť simuláciu platby na pokladnici

options:
  -h, --help            show this help message and exit
  -d                    enable debug info
```

Niektoré nastavenia sú priamo súčasťou skriptu (zatiaľ), a v prípade potreby je ich možné zmeniť priamo tam, konkrétne:
# defaults (pre integračné prostredie KVERKOM vo FRSR)
ERP_HOST_DEFAULT = "api-erp-i.kverkom.sk"
BANK_HOST_DEFAULT = "api-banka-i.kverkom.sk"
MQTT_HOST_DEFAULT = "mqtt-i.kverkom.sk"
MQTT_PORT_DEFAULT = 8883
TIMEOUT_S = 30

# cesty k lokálnymi súborom s certifikátmi a kľúčmi
CLIENT_CERT = ("./cert/kverkom-int-client.pem", "./cert/kverkom-int-client.key")
CA_BUNDLE = "./cert/kverkom-ca-bundle.pem"

Pre ďalšie detaily viď "KVERKOM - NOP Lite - Integračný manuál".
